*********************************
* Lambdas
*********************************

set more off

// Prepare ownership data

use "$inputs/thomson/thomson_data.dta", clear

keep if month(rdate)==12
drop if cusip==""
keep if inlist(stkcd,"0"," ","")
drop if inlist(exchcd,"I","J","K","W","Z")

gen year = year(rdate)


* keep the latest filed report
bys cusip mgrno rdate: egen maxfdate = max(fdate)
keep if fdate == maxfdate
drop maxfdate
drop prc

rename cusip ncusip
rename exchcd exchcd_thomson
merge m:1 ncusip year using "$inputs/crsp_yearly"
keep if _m==3
drop _m

gen mkt_cap = prc*shrout
drop if mkt_cap==.

// merge in the fixed mgrnos
gen mgrname_clean = subinstr(mgrname," ","",.)
foreach s in & ' ( ) * + , - . / _ {
	replace mgrname_clean = subinstr(mgrname_clean,"`s'","",.)
}
gen mgrno_original = mgrno
merge m:1 mgrno_original mgrname_clean using "$inputs\mgrno cleaned.dta"
keep if _m!=2
drop _merge
replace mgrno = mgrno_new if mgrno_new!=.

drop mgrname_clean 

replace no = 0 if no==.

gen beta = shares/(1000*shrout)
gen gamma = (shares-no) /(shrout*1000)

drop if beta==. | gamma==.



collapse (sum) beta gamma (mean) mkt_cap, by(ncusip cusip permco permno siccd mgrno year)



drop if mkt_cap<=0
gen nmkt_cap = -mkt_cap
sort year permco nmkt_cap permno
by year permco nmkt_cap permno: gen N = _n==1
by year permco: gen rank = sum(N)
keep if rank==1

drop N rank
sort year permco mgrno

save "$path_temp/ownership_all", replace



forvalues year = 1980/2017 {

disp "*******************"
disp "Year: `year'"
disp "*******************"


use "$path_temp/ownership_all", clear

keep if year==`year'

// Select largest 500 firms from the ownership data and drop very small holdings
sort year nmkt_cap permco
by year nmkt_cap permco: gen N = _n==1
by year: gen rank = sum(N)
keep if rank<=1500
drop if beta<=0.001
keep mgrno permco beta gamma year siccd mkt_cap
rename * *1
rename (mgrno1 year1) (mgrno year)
save "$path_temp/temp", replace
rename *1 *2
drop gamma2
save "$path_temp/temp2", replace

// Create list of firms to pair with
use "$path_temp/temp", clear
keep year permco1
rename permco1 permco2
duplicates drop
save "$path_temp/year_permco2", replace

// Create data at the firm-pair-mgrno level and calculate lambdas
use "$path_temp/temp", clear
joinby year using "$path_temp/year_permco2"
drop if permco1==permco2
merge m:1 year mgrno permco2 using "$path_temp/temp2"
sort year permco1 permco2
by year permco1 permco2: egen g1b2=sum( gamma1* beta2 )
by year permco1 permco2: egen g1b1=sum( gamma1* beta1 )
gen lambda = g1b2/g1b1
replace lambda=1 if lambda>=1
by year permco1 permco2: keep if _n==1
gen w = mkt_cap1* mkt_cap2

// Calculate lambda intra

preserve
keep if siccd1==siccd2
collapse (mean) lambda [aw=w], by(year)
rename lambda lambda_intra
rename year fyear
if `year'>1980 append using "$path_temp/lambda_intra"
save "$path_temp/lambda_intra", replace
restore

// Calculate lambda inter

preserve
keep if siccd1!=siccd2
collapse (mean) lambda [aw=w], by(year)
rename lambda lambda_inter
rename year fyear
if `year'>1980 append using "$path_temp/lambda_inter"
save "$path_temp/lambda_inter", replace
restore

}
